//************************************************************************************
//**  
//**  File name:     E:\Proget bac\RS232 Pic 16f874A.c
//**  Generated by:  Flowcode v4.2.3.58
//**  Date:          Thursday, February 21, 2013 18:01:52
//**  Licence:       50 User
//**  Registered to: LYCEE-LA-TOURELLE95
//**  
//**  
//**     POUR UN USAGE NON COMMERCIAL 
//**  
//**  http://www.matrixmultimedia.com
//************************************************************************************


#define MX_PIC

//Dfinir pour microcontrleur
#define P16F874A
#define MX_EE
#define MX_EE_SIZE 128
#define MX_SPI
#define MX_SPI_C
#define MX_SPI_SDI 4
#define MX_SPI_SDO 5
#define MX_SPI_SCK 3
#define MX_UART
#define MX_UART_C
#define MX_UART_TX 6
#define MX_UART_RX 7
#define MX_I2C
#define MX_MI2C
#define MX_I2C_C
#define MX_I2C_SDA 4
#define MX_I2C_SCL 3
#define MX_PWM
#define MX_PWM_CNT 2
#define MX_PWM_TRIS1 trisc
#define MX_PWM_1 2
#define MX_PWM_TRIS2 trisc
#define MX_PWM_2 1

//Fonctions
#define MX_CLK_SPEED 19660800
#ifdef _BOOSTC
#include <system.h>
#endif
#ifdef HI_TECH_C
#include <pic.h>
#endif

//Donnes de Configuration

//Fonctions internes
#include "C:\Program Files\Matrix Multimedia\Flowcode V4\FCD\internals.h"

//Dclarations de fonction Macro


//Dclarations de Variable
char FCV_COMMANDE;
char FCV_B1;
char FCV_B2;
char FCV_B3;
char FCV_B4;
char FCV_TIMEOUT;
char FCV_B5;
char FCV_B6;
char FCV_B7;
char FCV_CMPT;
char FCV_B0;


//Defines:

/**** Macro Substitutions ****
portc = RTS Port
trisc = RTS Data Direction
portc = CTS Port
trisc = CTS Data Direction
0 = RTS Pin
4 = CTS Pin
1 = UART Selection		(0-SW / 1-UART1 / 2-UART2)
0 = Flow Control		(0-Off / 1-On)
0 = Debug Enable		(0-Off / 1-On)
0 = Echo Enable		(0-Off / 1-On)
4 = UART TXSTA Value
127 = UART SPBRG Value
RS232_918884 = Unique ID
Unused = Bitbanged Receive Port Register
Unused = Bitbanged Receive Data Direction Register
Unused = Bitbanged Receive Pin
Unused = Bitbanged Transmit Pin
120 = Bitbanged BAUD Rate Delay
0 = Timout	Selection	(0-Legacy / 1-MS Timeout)
0 = Data Size			(0-8 bits / 1-9 bits / 2-7 bits & Only available on BitBanged components)
0 = Parity Enable		(0-No Parity / 1-Odd Parity / 2-Even Parity)
0 = Legacy Return		(0-Legacy mode return 255 / 1-New mode return MSB err flags)
Unused = Bitbanged Transmit Port Register
Unused = Bitbanged Transmit Data Direction Register
******************************/

#define RS232_918884_RTS_PORT			portc
#define RS232_918884_RTS_TRIS			trisc
#define RS232_918884_CTS_PORT			portc
#define RS232_918884_CTS_TRIS			trisc
#define RS232_918884_RTS_PIN			0
#define RS232_918884_CTS_PIN			4
#define RS232_918884_UART				1
#define RS232_918884_TOUT  			0
#define RS232_918884_DATASIZE			0
#define RS232_918884_PARITY			0
#define RS232_918884_LEGACY_RV			0

#if (0 == 1)
  	#define RS232_918884_HARDWARE
#endif

#if (0 == 1)
  	#define RS232_918884_DEBUG
#endif

#if (0 == 1)
  	#define RS232_918884_ECHO
#endif

#if (RS232_918884_UART == 0)
	#define RS232_918884_RX_PORT		Unused
	#define RS232_918884_RX_TRIS		Unused
	#define RS232_918884_SW_RX		Unused
	#define RS232_918884_SW_TX		Unused
	#define RS232_918884_SW_BAUD		120
	#define RS232_918884_TX_PORT		Unused
	#define RS232_918884_TX_TRIS		Unused
#else
	#define RS232_918884_TXSTA_VAL  	4
	#define RS232_918884_SPBRG_VAL  	127
	#define RS232_918884_SW_BAUD		0
#endif

#if (RS232_918884_LEGACY_RV == 0)
	#if (RS232_918884_DATASIZE == 1)
		#pragma error "RS232 Component cannot combine 9-bit data mode with legacy return value of 255 please check the Component properties"
	#endif
#endif

#define RS232_918884_STATUS_LOOP		0
#define RS232_918884_STATUS_TIMEOUT	1
#define RS232_918884_STATUS_RXBYTE	2





//RS2320: //Dclarations de fonction Macro

void FCD_RS2320_SendRS232Char(short nChar);
void FCD_RS2320_SendRS232String(char* String, char MSZ_String);
short FCD_RS2320_ReceiveRS232Char(short nTimeout);
void FCD_RS2320_ReceiveRS232String(char* FCR_RETVAL, char FCR_RETVAL_SIZE, char nTimeout, char NumBytes);
void FCD_RS2320_RS232_Delay(char mode);
//Defines:

/**** Macro Substitutions ****
{'1','4','7','*','2','5','8','0','3','6','9','#'} = Key List (Numbers)
{1,4,7,10,2,5,8,0,3,6,9,11} = Key List (Characters)
tris` = Row Data Direction Register
port` = Row Port Register
3 = Number Of Columns
4 = Number Of Rows
tris` = Column Data Direction Register
port` = Column Port Register
1 = Column 1 mask
1 = Column 2 mask
1 = Column 3 mask
1 = Column 4 mask
1 = Row 1 mask
1 = Row 2 mask
1 = Row 3 mask
1 = Row 4 mask
******************************/




//KeyPad0: //Dclarations de fonction Macro

char FCD_KeyPad0_GetKeypadNumber();
char FCD_KeyPad0_GetKeypadAscii();



//RS2320: //Implmentations Macro


void FCD_RS2320_SendRS232Char(short nChar)
{
	
	#if (RS232_918884_UART == 0)

		char dMask;
		char idx;
		char count = 8;

		#ifdef RS232_918884_HARDWARE
			//wait until CTS is low
			while (( RS232_918884_CTS_PORT & (1 << RS232_918884_CTS_PIN) ) != 0);
		#endif

		#if(RS232_918884_DATASIZE == 1)
			count = 9;
		#endif
		#if(RS232_918884_DATASIZE == 2)
			count = 7;
		#endif

		clear_bit( RS232_918884_TX_PORT, RS232_918884_SW_TX);		// Send Start bit
		FCD_RS2320_RS232_Delay(0);

		for (idx = 0; idx < count; idx++)
		{
			dMask = nChar & 0x01;							// Mask off data bit

			if (dMask)
				set_bit( RS232_918884_TX_PORT, RS232_918884_SW_TX);
			else
				clear_bit( RS232_918884_TX_PORT, RS232_918884_SW_TX);

			FCD_RS2320_RS232_Delay(0);
			nChar = nChar >> 1;								// Move to next data bit
		}

		set_bit( RS232_918884_TX_PORT, RS232_918884_SW_TX);			// Send Stop bit
		FCD_RS2320_RS232_Delay(0);

	#endif

	#if (RS232_918884_UART == 1)

		#ifndef MX_UART
			#pragma error "Chip does not have UART capability"
		#endif

		st_bit(txsta, TXEN);
		while (ts_bit(pir1, TXIF) == 0);

		#ifdef RS232_918884_HARDWARE
			//wait until CTS is low
			while (( RS232_918884_CTS_PORT & (1 << RS232_918884_CTS_PIN) ) != 0);
		#endif

		#if(RS232_918884_DATASIZE == 1)
			if (test_bit(nChar, 8))
				st_bit(txsta, TX9D);
			else
				cr_bit(txsta, TX9D);
		#endif

		txreg = nChar;

	#endif

	#if (RS232_918884_UART == 2)

		#ifndef MX_UART2
			#pragma error "Chip does not have second UART capability"
		#endif

		st_bit(txsta2, TXEN);
		while (ts_bit(pir3, TX2IF) == 0);

		#ifdef RS232_918884_HARDWARE
			//wait until CTS is low
			while (( RS232_918884_CTS_PORT & (1 << RS232_918884_CTS_PIN) ) != 0);
		#endif

		#if( RS232_918884_DATASIZE == 1)
			if (test_bit(nChar, 8))
				st_bit(txsta2, TX9D);
			else
				cr_bit(txsta2, TX9D);
		#endif

		txreg2 = nChar;

	#endif

}

void FCD_RS2320_SendRS232String(char* String, char MSZ_String)
{
		char idx;
		for(idx = 0; idx < MSZ_String; idx++)
		{
			#ifdef _BOOSTC
				if (String[idx] == 0)
					break;
				else FCD_RS2320_SendRS232Char(String[idx]);
			#endif
			#ifdef HI_TECH_
				if (*String == 0)
					break;
				else FCD_RS2320_SendRS232Char(*String);
				String++;
			#endif
		}
}

short FCD_RS2320_ReceiveRS232Char(short nTimeout)
{
	
		char delay1 = 0;
		char delay2 = 0;
		char regcheck = 0;
		char dummy = 0;
		short retVal = 512;
		char bWaitForever = 0;
		char rxStatus = RS232_918884_STATUS_LOOP;
		char idx;
		char count = 8;

		#if ( RS232_918884_LEGACY_RV == 0)
			retVal = 255;
		#endif

		#if ( RS232_918884_UART == 1)
			#ifndef MX_UART
				#pragma error "Chip does not have UART capability"
			#endif
		#endif

		#if ( RS232_918884_UART == 2)
			#ifndef MX_UART2
				#pragma error "Chip does not have second UART capability"
			#endif
		#endif

		#ifdef RS232_918884_HARDWARE
			//ready to accept data
			clear_bit( RS232_918884_RTS_PORT, RS232_918884_RTS_PIN);
		#endif

		if (nTimeout == 255)
			bWaitForever = 1;

		#if ( RS232_918884_UART == 1)
			st_bit(rcsta, CREN);
		#endif

		#if ( RS232_918884_UART == 2)
			st_bit(rcsta2, CREN);
		#endif

		while (rxStatus == RS232_918884_STATUS_LOOP)
		{
			if (bWaitForever == 0)
			{
				//don't wait forever, so do timeout thing...
				if (nTimeout == 0)
				{
					rxStatus = RS232_918884_STATUS_TIMEOUT;
				}
				else
				{
					if ( RS232_918884_TOUT)
					{
						delay_us(10);
						delay1 = delay1 + 1;
						if(delay1 == 100)
						{
							nTimeout = nTimeout - 1;
							delay1 = 0;
						}
					}
					else
					{
						//decrement timeout
						delay1 = delay1 - 1;
						if (delay1 == 0)
						{
							nTimeout = nTimeout - 1;
						}
					}
				}
			}

			#if ( RS232_918884_UART == 0)
				regcheck = test_bit(RS232_918884_RX_PORT, RS232_918884_SW_RX);	//Test for start bit
				if (regcheck == 0)
					rxStatus = RS232_918884_STATUS_RXBYTE;
			#endif

			#if ( RS232_918884_UART == 1)
				regcheck = ts_bit(pir1, RCIF);
				if (regcheck != 0)
					rxStatus = RS232_918884_STATUS_RXBYTE;
			#endif

			#if ( RS232_918884_UART == 2)
				regcheck = ts_bit(pir3, RC2IF);
				if (regcheck != 0)
					rxStatus = RS232_918884_STATUS_RXBYTE;
			#endif
		}

		if (rxStatus == RS232_918884_STATUS_RXBYTE)
		{
			#if ( RS232_918884_UART > 0)

				#if ( RS232_918884_UART == 1)
					regcheck = ts_bit(rcsta, FERR);
				#endif

				#if ( RS232_918884_UART == 2)
					regcheck = ts_bit(rcsta2, FERR);
				#endif

				if (regcheck != 0)
				{
					#if ( RS232_918884_UART == 1)
						dummy = rcreg;      //need to read the rcreg to clear FERR
					#endif

					#if ( RS232_918884_UART == 2)
						dummy = rcreg2;      //need to read the rcreg to clear FERR
					#endif

					#ifdef RS232_918884_DEBUG
						FCD_RS2320_SendRS232Char('<');
						FCD_RS2320_SendRS232Char('F');
						FCD_RS2320_SendRS232Char('E');
						FCD_RS2320_SendRS232Char('R');
						FCD_RS2320_SendRS232Char('R');
						FCD_RS2320_SendRS232Char('>');
					#endif

					#if ( RS232_918884_LEGACY_RV == 1)
						retVal = 0x400;					//Framing Error Flag
					#endif
				}
				else
				{
					#if ( RS232_918884_UART == 1)
						regcheck = ts_bit(rcsta, OERR);
					#endif

					#if ( RS232_918884_UART == 2)
						regcheck = ts_bit(rcsta2, OERR);
					#endif

					if (regcheck != 0)
					{
						//need to read the rcreg to clear error
						#if ( RS232_918884_UART == 1)
							cr_bit(rcsta, CREN);
							st_bit(rcsta, CREN);
						#endif

						#if ( RS232_918884_UART == 2)
							cr_bit(rcsta2, CREN);
							st_bit(rcsta2, CREN);
						#endif

						#ifdef RS232_918884_DEBUG
							FCD_RS2320_SendRS232Char('<');
							FCD_RS2320_SendRS232Char('O');
							FCD_RS2320_SendRS232Char('E');
							FCD_RS2320_SendRS232Char('R');
							FCD_RS2320_SendRS232Char('R');
							FCD_RS2320_SendRS232Char('>');
						#endif

						#if ( RS232_918884_LEGACY_RV == 1)
							retVal = 0x800;					//Overrun Error Flag
						#endif

					}
					else
					{
						#if ( RS232_918884_UART == 1)
							retVal = rcreg; 			//no error, so rx byte is valid

							#if( RS232_918884_DATASIZE == 1)
								if(ts_bit(rcsta, RX9D));
									retVal = retVal | 0x100;
							#endif

						#endif

						#if ( RS232_918884_UART == 2)
							retVal = rcreg2; 			//no error, so rx byte is valid

							#if( RS232_918884_DATASIZE == 1)
								if(ts_bit(rcsta2, RX9D));
									retVal = retVal | 0x100;
							#endif

						#endif

						#ifdef RS232_918884_ECHO
							FCD_RS2320_SendRS232Char(retVal);
						#endif
					}
				}
			#else
				#if( RS232_918884_DATASIZE == 1)
					count = 9;
				#endif

				FCD_RS2320_RS232_Delay(1);
				for (idx = 0; idx < count; idx++)
				{
					retVal = retVal >> 1;

					if(count == 9)
					{
						if (test_bit( RS232_918884_RX_PORT, RS232_918884_SW_RX))
							retVal = retVal | 0x100;
					}
					else
					{
						if (test_bit( RS232_918884_RX_PORT, RS232_918884_SW_RX))
							retVal = retVal | 0x80;
					}
					FCD_RS2320_RS232_Delay(1);
				}

				#ifdef RS232_918884_ECHO
					FCD_RS2320_SendRS232Char(retVal);
				#endif

			#endif
		}
		#ifdef RS232_918884_HARDWARE
			//not ready to accept data
			set_bit( RS232_918884_RTS_PORT, RS232_918884_RTS_PIN);
		#endif

		return (retVal);
}

void FCD_RS2320_ReceiveRS232String(char* FCR_RETVAL, char FCR_RETVAL_SIZE, char nTimeout, char NumBytes)
{
		char idx;
		short in;

		#if ( RS232_918884_LEGACY_RV == 0 )
			#define RS232_TO 	255
		#else
			#define RS232_TO 	256
		#endif

		if (NumBytes > FCR_RETVAL_SIZE)
			NumBytes = FCR_RETVAL_SIZE;

		for (idx = 0; idx < NumBytes; idx++)
		{
			in = FCD_RS2320_ReceiveRS232Char(nTimeout);
			if(in < RS232_TO)
				FCR_RETVAL[idx] = in & 0xFF;
			else
				break;
		}

		if (idx < FCR_RETVAL_SIZE)
			FCR_RETVAL[idx] = 0;

		#undef RS232_TO
}

void FCD_RS2320_RS232_Delay(char mode)
{
		unsigned int iterations;
		unsigned int delay = RS232_918884_SW_BAUD;

		if (mode)
			delay = delay + 1;

		for (iterations = 0; iterations < delay; iterations++);
}



//KeyPad0: //Implmentations Macro


char FCD_KeyPad0_GetKeypadNumber()
{
		//get matrices for rows and columns
		#if (3 == 1)
			#define KPAD_COL_MTX {1}
			#define KPAD_COL_MASK (1)
		#endif
		#if (3 == 2)
			#define KPAD_COL_MTX {1,1}
			#define KPAD_COL_MASK (1|1)
		#endif
		#if (3 == 3)
			#define KPAD_COL_MTX {1,1,1}
			#define KPAD_COL_MASK (1|1|1)
		#endif
		#if (3 == 4)
			#define KPAD_COL_MTX {1,1,1,1}
			#define KPAD_COL_MASK (1|1|1|1)
		#endif
		#if (4 == 1)
			#define KPAD_ROW_MTX {1}
			#define KPAD_ROW_MASK (1)
		#endif
		#if (4 == 2)
			#define KPAD_ROW_MTX {1,1}
			#define KPAD_ROW_MASK (1|1)
		#endif
		#if (4 == 3)
			#define KPAD_ROW_MTX {1,1,1}
			#define KPAD_ROW_MASK (1|1|1)
		#endif
		#if (4 == 4)
			#define KPAD_ROW_MTX {1,1,1,1}
			#define KPAD_ROW_MASK (1|1|1|1)
		#endif

		#ifndef KPAD_COL_MTX
			#pragma error Keypad error: column count is not 1-4
		#endif
		#ifndef KPAD_ROW_MTX
			#pragma error Keypad error: row count is not 1-4
		#endif

		//store keys and pin connections into a constant array
		#ifdef _BOOSTC
			rom char* mtxKeysAsNumbers = {1,4,7,10,2,5,8,0,3,6,9,11};
			rom char* mtxCols = KPAD_COL_MTX;
			rom char* mtxRows = KPAD_ROW_MTX;
		#endif
		#ifdef HI_TECH_C
			const char mtxKeysAsNumbers[] = {1,4,7,10,2,5,8,0,3,6,9,11};
			const char mtxCols[] = KPAD_COL_MTX;
			const char mtxRows[] = KPAD_ROW_MTX;
		#endif

		//set up i/o of port (rows = inputs, columns = outputs)
		tris` = (tris` | KPAD_ROW_MASK);
		tris` = (tris` & ~KPAD_COL_MASK);		//BR

		char iCol;
		char iRow;
		char c_ip;
		for (iCol=0; iCol<3; iCol++)
		{
			//output the appropriate column high
			port` = mtxCols[iCol];

			//delay
			delay_us(10);

			//read the port
			c_ip = port`;

			//check for a hit
			for (iRow=0; iRow<4; iRow++)
			{
				if ((c_ip & mtxRows[iRow]) != 0)
				{
					//found it!
					goto found_key;
				}
			}
		}

		//if it gets here, it has not been found...
		return (255);

	  found_key:
		return (mtxKeysAsNumbers[(iCol*4) + iRow]);

	  #undef KPAD_COL_MTX
	  #undef KPAD_ROW_MTX
	  #undef KPAD_COL_MASK
	  #undef KPAD_ROW_MASK

}

char FCD_KeyPad0_GetKeypadAscii()
{
		//get matrices for rows and columns
		#if (3 == 1)
			#define KPAD_COL_MTX {1}
			#define KPAD_COL_MASK (1)
		#endif
		#if (3 == 2)
			#define KPAD_COL_MTX {1,1}
			#define KPAD_COL_MASK (1|1)
		#endif
		#if (3 == 3)
			#define KPAD_COL_MTX {1,1,1}
			#define KPAD_COL_MASK (1|1|1)
		#endif
		#if (3 == 4)
			#define KPAD_COL_MTX {1,1,1,1}
			#define KPAD_COL_MASK (1|1|1|1)
		#endif
		#if (4 == 1)
			#define KPAD_ROW_MTX {1}
			#define KPAD_ROW_MASK (1)
		#endif
		#if (4 == 2)
			#define KPAD_ROW_MTX {1,1}
			#define KPAD_ROW_MASK (1|1)
		#endif
		#if (4 == 3)
			#define KPAD_ROW_MTX {1,1,1}
			#define KPAD_ROW_MASK (1|1|1)
		#endif
		#if (4 == 4)
			#define KPAD_ROW_MTX {1,1,1,1}
			#define KPAD_ROW_MASK (1|1|1|1)
		#endif

		#ifndef KPAD_COL_MTX
			#pragma error Keypad error: column count is not 1-4
		#endif
		#ifndef KPAD_ROW_MTX
			#pragma error Keypad error: row count is not 1-4
		#endif

		//store keys and pin connections into a constant array
		#ifdef _BOOSTC
			rom char* mtxKeysAsChars = {'1','4','7','*','2','5','8','0','3','6','9','#'};
			rom char* mtxCols = KPAD_COL_MTX;
			rom char* mtxRows = KPAD_ROW_MTX;
		#endif
		#ifdef HI_TECH_C
			const char mtxKeysAsChars[] = {'1','4','7','*','2','5','8','0','3','6','9','#'};
			const char mtxCols[] = KPAD_COL_MTX;
			const char mtxRows[] = KPAD_ROW_MTX;
		#endif

		//set up i/o of port (rows = inputs, columns = outputs)
		tris` = (tris` | KPAD_ROW_MASK);
		tris` = (tris` & ~KPAD_COL_MASK);

		char iCol;
		char iRow;
		char c_ip;
		for (iCol=0; iCol<3; iCol++)
		{
			//output the appropriate column high
			port` = mtxCols[iCol];

			//delay
			delay_us(10);

			//read the port
			c_ip = port`;

			//check for a hit
			for (iRow=0; iRow<4; iRow++)
			{
				if ((c_ip & mtxRows[iRow]) != 0)
				{
					//found it!
					goto found_key;
				}
			}
		}

		//if it gets here, it has not been found...
		return (255);

	  found_key:
		return (mtxKeysAsChars[(iCol*4) + iRow]);

	  #undef KPAD_COL_MTX
	  #undef KPAD_ROW_MTX
	  #undef KPAD_COL_MASK
	  #undef KPAD_ROW_MASK

}

//Implmentations Macro

void main()
{
	
	//Initialisation
	adcon1 = 0x07;

	
	#if (RS232_918884_UART == 0)
		set_bit(RS232_918884_RX_TRIS, RS232_918884_SW_RX);		// Receive pin is a input
		clear_bit(RS232_918884_TX_TRIS, RS232_918884_SW_TX);	// Transmit pin is a output
		set_bit(RS232_918884_TX_PORT, RS232_918884_SW_TX);		// Transmit pin is default high
	#endif

	#if (RS232_918884_UART == 1)
		txsta = RS232_918884_TXSTA_VAL;   					// 8-bit, async, low speed, off
		spbrg = RS232_918884_SPBRG_VAL;   					// set the baud rate
		rcsta = 0;                    				// 8-bit, disabled

		if(RS232_918884_DATASIZE == 1)
		{
			st_bit(txsta, TX9);   						// 9-bit TX
			st_bit(rcsta, RX9);                    	// 9-bit RX
		}

		st_bit(rcsta, SPEN);         					// turn on serial interface
	#endif

	#if (RS232_918884_UART == 2)

		txsta2 = RS232_918884_TXSTA_VAL;   					// 8-bit, async, low speed, off
		spbrg2 = RS232_918884_SPBRG_VAL;   					// set the baud rate
		rcsta2 = 0;                    					// 8-bit, disabled

		if(RS232_918884_DATASIZE == 1)
		{
			st_bit(txsta2, TX9);   					// 9-bit TX
			st_bit(rcsta2, RX9);                    	// 9-bit RX
		}

		st_bit(rcsta2, SPEN);         					// turn on serial interface
	#endif

	#ifdef RS232_918884_HARDWARE
		set_bit( RS232_918884_CTS_TRIS, RS232_918884_CTS_PIN);	//CTS is an input
		clear_bit( RS232_918884_RTS_TRIS, RS232_918884_RTS_PIN);	//RTS is an output
		set_bit( RS232_918884_RTS_PORT, RS232_918884_RTS_PIN); 	//not ready to accept data
	#endif


	//Code d'initialisation d'Interruption
	option_reg = 0xC0;


	//Calcul
	//Calcul:
	//  CMPT = 0
	FCV_CMPT = 0;
	

	//Position dpart
	//Calcul:
	//  B0 = 1
	//  B1 = 0
	//  B2 = 0
	//  B3 = 1
	//  B4 = 1
	//  B5 = 0
	//  B6 = 0
	//  B7 = 1
	FCV_B0 = 1;
	FCV_B1 = 0;
	FCV_B2 = 0;
	FCV_B3 = 1;
	FCV_B4 = 1;
	FCV_B5 = 0;
	FCV_B6 = 0;
	FCV_B7 = 1;
	

	//Sortie
	//Sortie: B0 -> B0
	trisb = trisb & 0xfe;
	if (FCV_B0)
		portb = (portb & 0xfe) | 0x01;
	else
		portb = portb & 0xfe;


	//Sortie
	//Sortie: B1 -> B1
	trisb = trisb & 0xfd;
	if (FCV_B1)
		portb = (portb & 0xfd) | 0x02;
	else
		portb = portb & 0xfd;


	//Sortie
	//Sortie: B2 -> B2
	trisb = trisb & 0xfb;
	if (FCV_B2)
		portb = (portb & 0xfb) | 0x04;
	else
		portb = portb & 0xfb;


	//Sortie
	//Sortie: B3 -> B3
	trisb = trisb & 0xf7;
	if (FCV_B3)
		portb = (portb & 0xf7) | 0x08;
	else
		portb = portb & 0xf7;


	//Sortie
	//Sortie: B4 -> B4
	trisb = trisb & 0xef;
	if (FCV_B4)
		portb = (portb & 0xef) | 0x10;
	else
		portb = portb & 0xef;


	//Sortie
	//Sortie: B5 -> B5
	trisb = trisb & 0xdf;
	if (FCV_B5)
		portb = (portb & 0xdf) | 0x20;
	else
		portb = portb & 0xdf;


	//Sortie
	//Sortie: B6 -> B6
	trisb = trisb & 0xbf;
	if (FCV_B6)
		portb = (portb & 0xbf) | 0x40;
	else
		portb = portb & 0xbf;


	//Sortie
	//Sortie: B7 -> B7
	trisb = trisb & 0x7f;
	if (FCV_B7)
		portb = (portb & 0x7f) | 0x80;
	else
		portb = portb & 0x7f;


	//Boucle
	//Boucle: Tant que 1
	while (1)
	{
		//Appel de la Routine Composant
		//Appel de la Routine Composant: commande=KeyPad(0)::GetKeypadNumber
		FCV_COMMANDE = FCD_KeyPad0_GetKeypadNumber();


		//Dcision
		//Dcision: commande=8?
		if (FCV_COMMANDE==8)
		{
			//Appel de la Routine Composant
			//Appel de la Routine Composant: commande=RS232(0)::ReceiveRS232Char(timeout)
			FCV_COMMANDE = FCD_RS2320_ReceiveRS232Char(FCV_TIMEOUT);


			//Calcul
			//Calcul:
			//  CMPT = CMPT+1
			FCV_CMPT = FCV_CMPT+1;
			

			//Dcision
			//Dcision: CMPT>8?
			if (FCV_CMPT>8)
			{
				//Calcul
				//Calcul:
				//  CMPT = 1
				FCV_CMPT = 1;
				

			}


			//Multi-Dcision
			//Multi-Dcision: CMPT?
			switch (FCV_CMPT)
			{
				case 1:
				{
					//Calcul
					//Calcul:
					//  B0 = 1
					//  B1 = 0
					//  B2 = 0
					//  B3 = 0
					FCV_B0 = 1;
					FCV_B1 = 0;
					FCV_B2 = 0;
					FCV_B3 = 0;
					

					break;
				}

				case 2:
				{
					//Calcul
					//Calcul:
					//  B0 = 1
					//  B1 = 1
					//  B2 = 0
					//  B3 = 0
					FCV_B0 = 1;
					FCV_B1 = 1;
					FCV_B2 = 0;
					FCV_B3 = 0;
					

					break;
				}

				case 3:
				{
					//Calcul
					//Calcul:
					//  B0 = 0
					//  B1 = 1
					//  B2 = 0
					//  B3 = 0
					FCV_B0 = 0;
					FCV_B1 = 1;
					FCV_B2 = 0;
					FCV_B3 = 0;
					

					break;
				}

				case 4:
				{
					//Calcul
					//Calcul:
					//  B0 = 0
					//  B1 = 1
					//  B2 = 1
					//  B3 = 0
					FCV_B0 = 0;
					FCV_B1 = 1;
					FCV_B2 = 1;
					FCV_B3 = 0;
					

					break;
				}

				case 5:
				{
					//Calcul
					//Calcul:
					//  B0 = 0
					//  B1 = 0
					//  B2 = 1
					//  B3 = 0
					FCV_B0 = 0;
					FCV_B1 = 0;
					FCV_B2 = 1;
					FCV_B3 = 0;
					

					break;
				}

				case 6:
				{
					//Calcul
					//Calcul:
					//  B0 = 0
					//  B1 = 0
					//  B2 = 1
					//  B3 = 1
					FCV_B0 = 0;
					FCV_B1 = 0;
					FCV_B2 = 1;
					FCV_B3 = 1;
					

					break;
				}

				case 7:
				{
					//Calcul
					//Calcul:
					//  B0 = 0
					//  B1 = 0
					//  B2 = 0
					//  B3 = 1
					FCV_B0 = 0;
					FCV_B1 = 0;
					FCV_B2 = 0;
					FCV_B3 = 1;
					

					break;
				}

				case 8:
				{
					//Calcul
					//Calcul:
					//  B0 = 1
					//  B1 = 0
					//  B2 = 0
					//  B3 = 1
					FCV_B0 = 1;
					FCV_B1 = 0;
					FCV_B2 = 0;
					FCV_B3 = 1;
					

					break;
				}

			}


			//Sortie
			//Sortie: B0 -> B0
			trisb = trisb & 0xfe;
			if (FCV_B0)
				portb = (portb & 0xfe) | 0x01;
			else
				portb = portb & 0xfe;


			//Sortie
			//Sortie: B1 -> B1
			trisb = trisb & 0xfd;
			if (FCV_B1)
				portb = (portb & 0xfd) | 0x02;
			else
				portb = portb & 0xfd;


			//Sortie
			//Sortie: B2 -> B2
			trisb = trisb & 0xfb;
			if (FCV_B2)
				portb = (portb & 0xfb) | 0x04;
			else
				portb = portb & 0xfb;


			//Sortie
			//Sortie: B3 -> B3
			trisb = trisb & 0xf7;
			if (FCV_B3)
				portb = (portb & 0xf7) | 0x08;
			else
				portb = portb & 0xf7;


			//Pause
			//Pause: 10 ms
			delay_ms(10);


		}


	}


	mainendloop: goto mainendloop;
}

void MX_INTERRUPT_MACRO(void)
{
}



